<!DOCTYPE html>
<html lang="ar" direction="rtl" dir="rtl" style="direction: rtl">

<head>
    <base href="" />
    <title>
        <?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>
        <?= (isset($title)) ? ' - ' . $title : '- لوحة التحكم' ?>
    </title>
    <meta charset="utf-8" />
    <meta name="description" content="نظام إدارة السندات / القسم التقني لشركة الريان" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <?php $assetsAdmin = 'assets'; ?>

    <link rel="shortcut icon"
        href="<?= (!empty($settings->icon)) ? base_url('uploads/logo/' . $settings->icon) : base_url('uploads/logo/icon.png') ?>" />

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Tajawal:300,400,500,600,700" />

    <link href="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.rtl.css" rel="stylesheet"
        type="text/css" />
    <link href="<?= base_url($assetsAdmin); ?>/css/style.bundle.rtl.css" rel="stylesheet" type="text/css" />

</head>

<body id="kt_body" class="app-blank">

    <script>
        var defaultThemeMode = "light"; var themeMode; if (document.documentElement) { if (document.documentElement.hasAttribute("data-bs-theme-mode")) { themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); } else { if (localStorage.getItem("data-bs-theme") !== null) { themeMode = localStorage.getItem("data-bs-theme"); } else { themeMode = defaultThemeMode; } } if (themeMode === "system") { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } document.documentElement.setAttribute("data-bs-theme", themeMode); }
    </script>


    <div class="d-flex flex-column flex-root"
        style="background-image: url(<?= base_url('uploads'); ?>/media/stock_bg.gif);">
        <div class="d-flex flex-column flex-column-fluid flex-lg-row">

            <div class="d-flex flex-center w-lg-50 pt-15 pt-lg-0 px-10">
                <div class="d-flex flex-center flex-lg-start flex-column">
                    <a href="<?= base_url(''); ?>" class="mb-7">
                        <img alt="<?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>"
                            src="<?= (!empty($settings->logo_dark)) ? base_url('uploads/logo/' . $settings->logo_dark) : base_url('uploads/logo/logod.svg') ?>"
                            class="h-60px" />
                    </a>
                </div>
            </div>

            <div class="d-flex flex-center w-lg-50 p-10">
                <div class="card rounded-3 w-md-550px w-100">
                    <div class="card-body p-10 p-lg-20">

                        <?php if (session()->has('errors')): ?>
                            <div class="alert alert-danger d-flex align-items-center p-5">
                                <span class="svg-icon svg-icon-2hx svg-icon-danger me-3"><svg
                                        xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-exclamation-diamond-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M9.05.435c-.58-.58-1.52-.58-2.1 0L.436 6.95c-.58.58-.58 1.519 0 2.098l6.516 6.516c.58.58 1.519.58 2.098 0l6.516-6.516c.58-.58.58-1.519 0-2.098L9.05.435zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                    </svg></span>
                                <div class="d-flex flex-column">
                                    <h4 class="mb-1 text-dark">هناك خطأ!</h4>
                                    <?php foreach (session('errors') as $error): ?>
                                        <span>
                                            <?= $error ?>
                                        </span>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif ?>


                        <?= form_open('password/processReset/' . $token); ?>

                        <div class="text-center mb-11">
                            <h1 class="text-dark fw-bolder mb-3">استعادة كلمة المرور</h1>
                            <div class="text-gray-500 fw-semibold fs-6">نموذج طلب استعادة كلمة المرور</div>
                        </div>

                        <div class="fv-row mb-3">
                            <input type="password" name="password" id="password" class="form-control bg-transparent"
                                placeholder="كلمة المرور">
                        </div>

                        <div class="fv-row mb-3">
                            <input type="password" name="password_confirmation" id="password_confirmation" class="form-control bg-transparent"
                                placeholder="إعادة كلمة المرور">
                        </div>

                        <div class="d-grid mb-10">
                            <button type="submit" class="btn btn-primary">
                                <span class="indicator-label">استعادة كلمة المرور</span>
                                <span class="indicator-progress">برجاء الانتظار ...
                                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                        </div>

                        <?= form_close() ?>

                    </div>
                </div>
            </div>
        </div>

    </div>


    <script>var hostUrl = "<?= base_url($assetsAdmin); ?>/";</script>

    <script src="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.js"></script>
    <script src="<?= base_url($assetsAdmin); ?>/js/scripts.bundle.js"></script>


    <?php if (session()->has('warning')): ?>
        <script>
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            };

            toastr.warning("<?= session('warning'); ?>");
        </script>
    <?php endif; ?>
    <?php if (session()->has('info')): ?>
        <script>
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            };

            toastr.success("<?= session('info'); ?>");
        </script>
    <?php endif; ?>
    <?php if (session()->has('error')): ?>
        <script>
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            };

            toastr.error("<?= session('error'); ?>");
        </script>
    <?php endif; ?>

</body>

</html>