<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>الإعدادات العامة</h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <?php if (session()->has('errors')): ?>
                <div class="alert alert-danger d-flex align-items-center p-5">
                    <span class="svg-icon svg-icon-2hx svg-icon-danger me-3"><svg xmlns="http://www.w3.org/2000/svg"
                            width="16" height="16" fill="currentColor" class="bi bi-exclamation-diamond-fill"
                            viewBox="0 0 16 16">
                            <path
                                d="M9.05.435c-.58-.58-1.52-.58-2.1 0L.436 6.95c-.58.58-.58 1.519 0 2.098l6.516 6.516c.58.58 1.519.58 2.098 0l6.516-6.516c.58-.58.58-1.519 0-2.098L9.05.435zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                        </svg></span>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-dark">هناك خطأ!</h4>
                        <?php foreach (session('errors') as $error): ?>
                            <span>
                                <?= $error ?>
                            </span>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif ?>



            <?= form_open_multipart('dashboard/settings/update') ?>
            <?= csrf_field() ?>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="site_title"><span class="required">اسم
                        النظام</span></label>
                <input type="text" class="form-control form-control-solid" name="site_title" id="site_title"
                    value="<?= old('site_title', esc($settings->site_title)) ?>" required>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="about_text"><span>نبذة
                        تعريفية</span></label>
                <textarea name="about_text" id="about_text"
                    class="form-control form-control-solid"><?= old('about_text', esc($settings->about_text)) ?></textarea>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="logo"><span>شعار الموقع</span></label>
                <input type="file" class="form-control form-control-solid" name="logo" id="logo" />
                <br>
                <img src="<?= (isset($settings->logo)) ? base_url('uploads/logo/' . $settings->logo) : base_url('uploads/logo/logo.svg') ?>"
                    class="img-thumbnail" style="max-width: 200px;">
            </div>
            
            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="logo_dark"><span>شعار الموقع الوضع المظلم</span></label>
                <input type="file" class="form-control form-control-solid" name="logo_dark" id="logo_dark" />
                <br>
                <img src="<?= (isset($settings->logo_dark)) ? base_url('uploads/logo/' . $settings->logo_dark) : base_url('uploads/logo/logod.svg') ?>"
                    class="img-thumbnail" style="max-width: 200px; background-color: #000000;">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="icon"><span>أيقونة الموقع</span></label>
                <input type="file" class="form-control form-control-solid" name="icon" id="icon" />
                <br>
                <img src="<?= (isset($settings->icon)) ? base_url('uploads/logo/' . $settings->icon) : base_url('uploads/logo/icon.png') ?>"
                    class="img-thumbnail" style="max-width: 100px;">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="address"><span>عنوان
                        الشركة</span></label>
                <input type="text" class="form-control form-control-solid" name="address" id="address"
                    value="<?= old('address', esc($settings->address)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="email"><span>بريد الدعم</span></label>
                <input type="email" class="form-control form-control-solid" name="email" id="email"
                    value="<?= old('email', esc($settings->email)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="re_phone"><span>هاتف الدعم</span></label>
                <input type="tel" class="form-control form-control-solid" name="re_phone" id="re_phone"
                    value="<?= old('re_phone', esc($settings->re_phone)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="phone"><span>الهاتف</span></label>
                <input type="tel" class="form-control form-control-solid" name="phone" id="phone"
                    value="<?= old('phone', esc($settings->phone)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="facebook"><span>Facebook</span></label>
                <input type="text" class="form-control form-control-solid" name="facebook" id="facebook"
                    value="<?= old('facebook', esc($settings->facebook)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="twitter"><span>Twitter</span></label>
                <input type="text" class="form-control form-control-solid" name="twitter" id="twitter"
                    value="<?= old('twitter', esc($settings->twitter)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="instagram"><span>Instagram</span></label>
                <input type="text" class="form-control form-control-solid" name="instagram" id="instagram"
                    value="<?= old('instagram', esc($settings->instagram)) ?>">
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="youtube"><span>Youtube</span></label>
                <input type="text" class="form-control form-control-solid" name="youtube" id="youtube"
                    value="<?= old('youtube', esc($settings->youtube)) ?>">
            </div>


            <div class="separator mb-6"></div>

            <div class="d-flex justify-content-end">

                <button type="submit" class="btn btn-primary">
                    <span class="indicator-label">حفظ</span>
                    <span class="indicator-progress">برجاء الانتظار ...
                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                </button>

            </div>

            <?= form_close() ?>

        </div>
    </div>
</div>