<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>سلة المهملات</h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <?php if (!empty($messages)): ?>
                <div class="mb-3">
                    <a href="<?= site_url('dashboard/contact_messages/emptyTrash') ?>" class="btn btn-danger my-1"
                        onclick="return confirm('هل ترغب بتأكيد حذف كافة الرسائل في سلة المهملات بشكل نهائي؟')">إفراغ سلة
                        المهملات</a>
                </div>
            <?php endif; ?>

            <table id="table_data" class="table  table-row-bordered border rounded gy-5 gs-7">
                <thead>
                    <tr class="fw-bold fs-6 text-gray-800 px-7">
                        <th>المرسل</th>
                        <th>البريد الالكتروني</th>
                        <th>العنوان</th>
                        <th class="text-end">الخيارات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($messages)): ?>
                        <tr>
                            <td> لا توجد رسائل</td>
                            <td></td>
=                            <td></td>
                            <td class="text-end"></td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($messages as $message): ?>
                            <tr>
                                <td>
                                    <?= esc($message['name']) ?>
                                </td>
                                <td>
                                    <?= esc($message['email']) ?>
                                </td>
                                <td>
                                    <?= esc($message['subject']) ?>
                                </td>

                                <td class="text-end">
                                    <a href="<?= site_url('dashboard/contact_messages/' . $message['id']) ?>"
                                        class="btn btn-light-info my-1">عرض الرسالة</a>
                                    <a href="<?= site_url('dashboard/contact_messages/delete/' . $message['id']) ?>"
                                        class="btn btn-danger my-1"
                                        onclick="return confirm('هل ترغب بتأكيد حذف هذه الرسالة بشكل نهائي؟')">حذف</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>