<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>
                    <?php if ($voucher->voucher_type == 'receipt'): ?>
                        سند القبض:
                    <?php elseif ($voucher->voucher_type == 'payment'): ?>
                        سند الصرف:
                    <?php endif; ?>

                    <?= esc($voucher->title); ?>
                </h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <div class="mw-lg-950px mx-auto w-100">

                <div class="pb-12">

                    <div class="d-flex flex-column gap-7 gap-md-10">

                        <div class="row">
                            <div class="col-sm-3">
                                <span class="text-bold fs-1">
                                    <?php if ($voucher->voucher_type == 'receipt'): ?>
                                        استلمنا من المكرم:
                                    <?php elseif ($voucher->voucher_type == 'payment'): ?>
                                        المستلم:
                                    <?php endif; ?>
                                </span>
                            </div>
                            <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                                <span class="text-bold fs-3">
                                    <?= esc($voucher->recipient_name); ?>
                                </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-3">
                                <span class="text-bold fs-1">
                                    التاريخ:
                                </span>
                            </div>
                            <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                                <span class="text-bold fs-3">
                                    <?= date('Y-m-d', strtotime($voucher->created_at)); ?>
                                </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-3">
                                <span class="text-bold fs-1">
                                    رقم الوثيقة
                                </span>
                            </div>
                            <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                                <span class="text-bold fs-3">
                                    <?= esc($voucher->serial_number); ?>
                                </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-3">
                                <span class="text-bold fs-1">
                                    المبلغ:
                                </span>
                            </div>
                            <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                                <span class="text-bold fs-3">
                                    <?= esc($voucher->amount_number); ?>
                                </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-3">
                                <span class="text-bold fs-1">
                                    وذلك قيمة:
                                </span>
                            </div>
                            <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                                <span class="text-bold fs-3">
                                    <?= esc($voucher->title); ?>
                                </span>
                            </div>
                        </div>

                        <div class="separator"></div>

                        <div class="d-flex flex-column flex-sm-row gap-7 gap-md-10 fw-bold text-center">

                            <div class="flex-root d-flex flex-column">
                                <span class="text-bold fs-1">أمين الصندوق</span>
                                <span class="fs-5">
                                    <?= esc($voucher->cashier_name); ?>
                                </span>
                            </div>

                            <?php if ($voucher->voucher_type == 'payment'): ?>
                                <div class="flex-root d-flex flex-column">
                                    <span class="text-bold fs-1">المستلم</span>
                                    <span class="fs-5">
                                        <?= esc($voucher->recipient_name); ?>
                                    </span>
                                </div>
                            <?php endif; ?>

                            <div class="flex-root d-flex flex-column">
                                <span class="text-bold fs-1">المراجعة</span>
                                <span class="fs-5">
                                    <?= esc($voucher->review_name); ?>
                                </span>
                            </div>

                            <div class="flex-root d-flex flex-column">
                                <span class="text-bold fs-1">الاعتماد</span>
                                <span class="fs-5">
                                    <?= esc($voucher->accreditation_name); ?>
                                </span>
                            </div>

                        </div>

                    </div>

                </div>


                <div class="d-flex flex-stack flex-wrap mt-lg-20 pt-13">
                    <div class="my-1 me-5">
                        <a href="<?= site_url('dashboard/voucher/printAll/' . $voucher->id) ?>"
                            class="btn btn-success my-1 me-12" target="_blank">
                            طباعة كامل الوثيقة
                        </a>
                    </div>

                    <a href="<?= site_url('dashboard/voucher/print/' . $voucher->id) ?>" class="btn btn-primary my-1"
                        target="_blank">
                        طباعة البيانات فقط
                    </a>
                </div>

            </div>

            <script type="text/javascript">
                function printDiv() {
                    var printContents = document.getElementById("printable-content").innerHTML;
                    var originalContents = document.body.innerHTML;
                    document.body.innerHTML = printContents;
                    window.print();
                    document.body.innerHTML = originalContents;
                }
            </script>

        </div>
    </div>
</div>