<!DOCTYPE html>
<html lang="ar" direction="rtl" dir="rtl" style="direction: rtl">

<head>
    <base href="" />
    <title>
        <?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>
        <?= (isset($title)) ? ' - ' . $title : '- لوحة التحكم' ?>
    </title>
    <meta charset="utf-8" />
    <meta name="description" content="نظام إدارة السندات / القسم التقني لشركة الريان" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <?php $assetsAdmin = 'assets'; ?>

    <link rel="shortcut icon"
        href="<?= (!empty($settings->icon)) ? base_url('uploads/logo/' . $settings->icon) : base_url('uploads/logo/icon.png') ?>" />

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Tajawal:300,400,500,600,700" />

    <link href="<?= base_url($assetsAdmin); ?>/plugins/custom/prismjs/prismjs.bundle.rtl.css" rel="stylesheet"
        type="text/css" />

    <link href="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.rtl.css" rel="stylesheet"
        type="text/css" />
    <link href="<?= base_url($assetsAdmin); ?>/css/style.bundle.rtl.css" rel="stylesheet" type="text/css" />

    <link rel="stylesheet" href="<?= base_url($assetsAdmin); ?>/css/print.css" media="print">

</head>

<body>



    <div class="mw-lg-950px mx-auto w-100">

        <div id="printable-content">

            <span style="padding-top: 1in;"></span>

            <div class="d-flex justify-content-between flex-column flex-sm-row mb-19">
                <div class="text-sm-start">
                    <a href="#" class="d-block ms-sm-auto">
                        <img alt="<?= (!empty($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>"
                            src="<?= (!empty($settings->logo)) ? base_url('uploads/logo/' . $settings->logo) : base_url('uploads/logo/logo.svg') ?>"
                            class="w-100" />
                    </a>
                    <div class="text-sm-start fw-semibold fs-4 text-muted mt-7">
                        <div>نظام إدارة سندات الصرف والقبض</div>
                    </div>
                </div>
                <div class="text-sm-end">
                    <div class="text-sm-start fw-semibold fs-4 text-muted mt-7">
                        <div>التاريخ:
                            <?= date('Y-m-d', strtotime($voucher->created_at)); ?>
                        </div>
                        <div>رقم الوثيقة:
                            <?= esc($voucher->serial_number); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="pb-12">

                <div class="d-flex flex-column gap-7 gap-md-10">

                    <?php if ($voucher->voucher_type == 'receipt'): ?>
                        <div class="col-sm-12 text-center">
                            <h1>سند قبض نقدية</h1>
                        </div>
                    <?php elseif ($voucher->voucher_type == 'payment'): ?>
                        <div class="col-sm-12 text-center">
                            <h1>سند صرف نقدية</h1>
                            <h3>تحية طيبة وبعد</h3>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-sm-3">
                            <span class="text-bold fs-1">
                                <?php if ($voucher->voucher_type == 'receipt'): ?>
                                    استلمنا من المكرم:
                                <?php elseif ($voucher->voucher_type == 'payment'): ?>
                                    المستلم:
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                            <span class="text-bold fs-3">
                                <?= esc($voucher->recipient_name); ?>
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-3">
                            <span class="text-bold fs-1">
                                المبلغ:
                            </span>
                        </div>
                        <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                            <span class="text-bold fs-3">
                                <?= esc($voucher->amount_number); ?>
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-3">
                            <span class="text-bold fs-1">
                                فقط وقدره:
                            </span>
                        </div>
                        <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                            <span class="text-bold fs-3">
                                ***
                                <?= esc($voucher->amount_text); ?>
                                /
                                ريالاً سعودياً
                                ***
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-3">
                            <span class="text-bold fs-1">
                                وذلك قيمة:
                            </span>
                        </div>
                        <div class="col-sm-9" style="border-bottom: 2px dotted rgba(0, 0, 0, 0.5);">
                            <span class="text-bold fs-3">
                                <?= esc($voucher->title); ?>
                            </span>
                        </div>
                    </div>

                    <br>
                    <div class="col-sm-12 text-center">
                        <div class="fw-bold fs-4">رقم التحقق:
                            <span class="text-muted fs-5">
                                <?= esc($voucher->verify_code); ?>
                            </span>
                        </div>
                    </div>

                    <div class="separator"></div>

                    <div class="d-flex flex-column flex-sm-row gap-7 gap-md-10 fw-bold text-center">

                        <div class="flex-root d-flex flex-column">
                            <span class="text-bold fs-1">أمين الصندوق</span>
                            <span class="fs-5">
                                <?= esc($voucher->cashier_name); ?>
                            </span>
                        </div>

                        <?php if ($voucher->voucher_type == 'payment'): ?>
                            <div class="flex-root d-flex flex-column">
                                <span class="text-bold fs-1">المستلم</span>
                                <span class="fs-5">
                                    <?= esc($voucher->recipient_name); ?>
                                </span>
                            </div>
                        <?php endif; ?>

                        <div class="flex-root d-flex flex-column">
                            <span class="text-bold fs-1">المراجعة</span>
                            <span class="fs-5">
                                <?= esc($voucher->review_name); ?>
                            </span>
                        </div>

                        <div class="flex-root d-flex flex-column">
                            <span class="text-bold fs-1">الاعتماد</span>
                            <span class="fs-5">
                                <?= esc($voucher->accreditation_name); ?>
                            </span>
                        </div>

                    </div>

                </div>

            </div>

        </div>


        <div class="d-flex flex-stack flex-wrap mt-lg-20 pt-13">
            <div class="my-1 me-5">
                <button type="button" class="btn btn-success my-1 me-12" onclick="printDiv()">
                    طباعة
                </button>
            </div>
        </div>

    </div>

    <script type="text/javascript">
        function printDiv() {
            var printContents = document.getElementById("printable-content").innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>




    <script>var hostUrl = "<?= base_url($assetsAdmin); ?>/";</script>

    <script src="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.js"></script>
    <script src="<?= base_url($assetsAdmin); ?>/js/scripts.bundle.js"></script>
</body>

</html>