<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>قائمة الأعضاء</h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <table id="table_data" class="table table-row-bordered border rounded gy-5 gs-7">
                <thead>
                    <tr class="fw-bold fs-6 text-gray-800 px-7">
                        <th>الاسم</th>
                        <th>البريد</th>
                        <th>نشط؟</th>
                        <th>مدير؟</th>
                        <th>أنشئ بتاريخ</th>
                        <th>الخيارات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($users): ?>
                        <?php foreach ($users as $user): ?>

                            <tr>
                                <td>
                                    <?= esc($user->name) ?>
                                </td>
                                <td>
                                    <?= esc($user->email) ?>
                                </td>
                                <td>
                                    <?= $user->is_active ? 'نعم' : 'لا' ?>
                                </td>
                                <td>
                                    <?= $user->is_admin ? 'نعم' : 'لا' ?>
                                </td>
                                <td>
                                    <?= $user->created_at ?>
                                </td>
                                <td>
                                    <a href="<?= base_url('dashboard/users/' . $user->id); ?>">تعديل</a>
                                </td>
                            </tr>

                        <?php endforeach; ?>
                    <?php else: ?>

                        <tr>
                            <td colspan="6">
                                لا يوجد أي عضو
                            </td>
                        </tr>

                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>