<?php

namespace App\Controllers;

class Profile extends BaseController
{
    private $user;
    private $Settingsmodel;
    
    public function __construct()
    {
        $this->user = service('auth')->getCurrentUser();
        $this->myUser = service('auth')->getCurrentUser();
        $this->Settingsmodel = new \App\Models\GeneralSettingsModel;
    }
    
    public function show()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'الملف الشخصي';

        $data['myUser'] = $this->myUser;

        $data['user'] = $this->user;
		$data['page'] = view('Profile/show', $data);

		return view('Admin/layouts/default', $data);
    }
     
    public function edit()
    {
        $session = session();
        
        if ( ! $session->has('can_edit_profile_until')) {
            
            return redirect()->to('dashboard/profile/authenticate');
            
        }
        
        if ($session->get('can_edit_profile_until') < time()) {
            
            return redirect()->to('dashboard/profile/authenticate');
            
        }
        
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'تعديل الملف الشخصي';

        $data['myUser'] = $this->myUser;

        $data['user'] = $this->user;
		$data['page'] = view('Profile/edit', $data);

		return view('Admin/layouts/default', $data);
    }

    public function editPassword()
    {
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'تغيير كلمة المرور';

        $data['myUser'] = $this->myUser;

		$data['page'] = view('Profile/edit_password', $data);

		return view('Admin/layouts/default', $data);

    }

    public function authenticate()
    {
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'التحقق الأمني';

        $data['myUser'] = $this->myUser;

		$data['page'] = view('Profile/authenticate', $data);

		return view('Admin/layouts/default', $data);

    }

    public function image()
    {
        if ($this->user->profile_image) {
            
            $path = WRITEPATH . 'uploads/profile_images/' . $this->user->profile_image;
        
            $finfo = new \finfo(FILEINFO_MIME);
            
            $type = $finfo->file($path);
            
            header("Content-Type: $type");
            header("Content-Length: " . filesize($path));
            
            readfile($path);
            exit;
        }
    }

    //--------------------------------------

    public function update()
    {
        $this->user->fill($this->request->getPost());
        
        if ( ! $this->user->hasChanged()) {
            
            return redirect()->back()
                             ->with('warning', 'لا توجد أي بيانات جديدة')
                             ->withInput();
        }
        
        $model = new \App\Models\UserModel;
        
        if ($model->save($this->user)) {
            
            return redirect()->to('dashboard/profile')
                             ->with('info', 'تم تحديث البيانات بنجاح');
        } else {
            
            return redirect()->back()
                             ->with('errors', $model->errors())
                             ->with('warning', 'هناك خطأ ما!')
                             ->withInput();
        }
    }
    

    public function updatePassword()
    {
        if ( ! $this->user->verifyPassword($this->request->getPost('current_password'))) {
            
            return redirect()->back()
                             ->with('warning', 'كلمة المرور الحالية غير صحيحة');
        }
        
        $this->user->fill($this->request->getPost());
        
        $model = new \App\Models\UserModel;
        
        if ($model->save($this->user)) {
            
            return redirect()->to('dashboard/profile')
                             ->with('info', 'تم تحديث كلمة المرور بنجاح');
        } else {
            
            return redirect()->back()
                             ->with('errors', $model->errors())
                             ->with('warning', 'هناك خطأ ما!');
        }
    }

    public function processAuthenticate()
    {
        if ($this->user->verifyPassword($this->request->getPost('password'))) {
            
            session()->set('can_edit_profile_until', time() + 300);
            
            return redirect()->to('dashboard/profile/edit');
            
        } else {
            
            return redirect()->back()
                             ->with('warning', 'كلمة المرور غير صحيحة');
        }
    }

}