<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="utf-8">
    <title>الصفحة غير موجودة / خطأ 404</title>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Tajawal:300,400,500,600,700" />

    <style>
        * {
            transition: all 0.6s;
        }

        html {
            height: 100%;
            background: #720D21 url('data:image/png;base64,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');
        }

        body {
            font-family: 'Tajawal', sans-serif;
            color: #FBFAF7;
            margin: 0;
        }

        #main {
            display: table;
            width: 100%;
            height: 100vh;
            text-align: center;
        }

        .fof {
            display: table-cell;
            vertical-align: middle;
        }

        .fof h1 {
            font-size: 50px;
            display: inline-block;
            padding-right: 12px;
            animation: type .5s alternate infinite;
        }

        @keyframes type {
            from {
                box-shadow: inset -3px 0px 0px #d4b172;
            }

            to {
                box-shadow: inset -3px 0px 0px transparent;
            }
        }
    </style>
</head>

<body>

    <div id="main">
        <div class="fof">
            <h1>خطأ 404</h1>

            <?php if (ENVIRONMENT !== 'production'): ?>
                <h3 dir="ltr">
                    <?= nl2br(esc($message)) ?>
                </h3>
            <?php else: ?>
                <h3>
                    الصفحة غير موجودة
                </h3>
            <?php endif ?>

            <a href="<?= base_url(''); ?>" style="text-decoration:none; color: #d4b172; font-size: 25px; border-radius: 25px; border: 2px solid #d4b172; padding: 5px;">العودة للصفحة
                الرئيسية</a>
        </div>
    </div>

</body>

</html>