<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;

class Voucher extends BaseController
{
    private $myUser;
    private $Settingsmodel;
    private $model;

    public function __construct()
    {
        $this->myUser = service('auth')->getCurrentUser();
        $this->Settingsmodel = new \App\Models\GeneralSettingsModel;
        $this->model = new \App\Models\VoucherModel;
    }

    public function index()
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
        $data['title'] = 'كافة السندات';

        $data['myUser'] = $this->myUser;
        $data['vouchers'] = $this->model->findAll();

        $data['page'] = view('Admin/Voucher/index', $data);

        return view('Admin/layouts/default', $data);
    }

    public function show($id)
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();

        $voucher = $this->model->find($id);

        if (empty($voucher)) {
            return redirect()->back()->with('warning', 'الوثيقة غير متوفرة');
        }
        $data['title'] = $voucher->title;

        $data['myUser'] = $this->myUser;
        $data['voucher'] = $voucher;

        $data['page'] = view('Admin/Voucher/show', $data);

        return view('Admin/layouts/default', $data);
    }

    public function print($id)
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();

        $voucher = $this->model->find($id);

        if (empty($voucher)) {
            return redirect()->back()->with('warning', 'الوثيقة غير متوفرة');
        }
        $data['title'] = $voucher->title;

        $data['myUser'] = $this->myUser;
        $data['voucher'] = $voucher;

        return view('Admin/Voucher/print', $data);
    }

    public function edit($id)
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();

        $voucher = $this->model->find($id);

        if (empty($voucher)) {
            return redirect()->back()->with('warning', 'الوثيقة غير متوفرة');
        }
        $data['title'] = $voucher->title;

        $data['myUser'] = $this->myUser;
        $data['voucher'] = $voucher;

        $data['page'] = view('Admin/Voucher/edit', $data);

        return view('Admin/layouts/default', $data);
    }

    public function indexReceipt()
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
        $data['title'] = 'سندات القبض';

        $data['myUser'] = $this->myUser;
        $data['vouchers'] = $this->model->getvouchersByType('receipt');
        $data['type'] = 'receipt';

        $data['page'] = view('Admin/Voucher/indexReceipt', $data);

        return view('Admin/layouts/default', $data);
    }

    public function newReceipt()
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
        $data['title'] = 'إضافة سند قبض';

        $data['myUser'] = $this->myUser;

        $data['page'] = view('Admin/Voucher/newReceipt', $data);

        return view('Admin/layouts/default', $data);
    }

    public function indexPayment()
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
        $data['title'] = 'سندات الصرف';

        $data['myUser'] = $this->myUser;
        $data['vouchers'] = $this->model->getvouchersByType('payment');
        $data['type'] = 'payment';

        $data['page'] = view('Admin/Voucher/indexPayment', $data);

        return view('Admin/layouts/default', $data);
    }

    public function newPayment()
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
        $data['title'] = 'إضافة سند صرف';

        $data['myUser'] = $this->myUser;

        $data['page'] = view('Admin/Voucher/newPayment', $data);

        return view('Admin/layouts/default', $data);
    }

    public function trash()
    {
        $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
        $data['title'] = 'قائمة السندات المحذوفة';

        $data['myUser'] = $this->myUser;
        $data['vouchers'] = $this->model->onlyDeleted()->findAll();

        $data['page'] = view('Admin/Voucher/trash', $data);

        return view('Admin/layouts/default', $data);
    }

    //--------------------------------------

    public function createReceipt()
    {
        do {
            $serial_number = mt_rand(10000000, 99999999);
        } while ($this->model->where('serial_number', $serial_number)->first() !== null);

        do {
            $verify_code = mt_rand(100000, 999999);
        } while ($this->model->where('verify_code', $verify_code)->first() !== null);

        $data = [
            'serial_number' => $serial_number,
            'verify_code' => $verify_code,
            'created_by' => $this->myUser->id,
            'place_id' => 1,
            'voucher_type' => 'receipt',

            'title' => $this->request->getPost('title'),

            'amount_number' => $this->request->getPost('amount_number'),
            'amount_text' => $this->request->getPost('amount_text'),

            'cashier_name' => $this->request->getPost('cashier_name'),
            'review_name' => $this->request->getPost('review_name'),
            'accreditation_name' => $this->request->getPost('accreditation_name'),
            'recipient_name' => $this->request->getPost('recipient_name'),

            'is_accredited' => 0,
            'is_deleted' => 0,
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // if ($mediaFile = $this->request->getFile('media_file')) {
        //     $newName = $mediaFile->getRandomName();
        //     $mediaFile->move(WRITEPATH . 'uploads', $newName);
        //     $data['media_file'] = $newName;
        // }

        if ($this->model->insert($data)) {
            return redirect()->to('dashboard/voucher/' . $this->model->insertID)
                ->with('info', 'تم إضافة سند القبض بنجاح');
        } else {
            return redirect()->back()
                ->with('warning', 'هناك خطأ ما')
                ->withInput();
        }

    }

    public function createPayment()
    {
        do {
            $serial_number = mt_rand(10000000, 99999999);
        } while ($this->model->where('serial_number', $serial_number)->first() !== null);

        do {
            $verify_code = mt_rand(100000, 999999);
        } while ($this->model->where('verify_code', $verify_code)->first() !== null);

        $data = [
            'serial_number' => $serial_number,
            'verify_code' => $verify_code,
            'created_by' => $this->myUser->id,
            'place_id' => 1,
            'voucher_type' => 'payment',

            'title' => $this->request->getPost('title'),

            'amount_number' => $this->request->getPost('amount_number'),
            'amount_text' => $this->request->getPost('amount_text'),

            'cashier_name' => $this->request->getPost('cashier_name'),
            'review_name' => $this->request->getPost('review_name'),
            'accreditation_name' => $this->request->getPost('accreditation_name'),
            'recipient_name' => $this->request->getPost('recipient_name'),

            'is_accredited' => 0,
            'is_deleted' => 0,
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // if ($mediaFile = $this->request->getFile('media_file')) {
        //     $newName = $mediaFile->getRandomName();
        //     $mediaFile->move(WRITEPATH . 'uploads', $newName);
        //     $data['media_file'] = $newName;
        // }

        if ($this->model->insert($data)) {
            return redirect()->to('dashboard/voucher/' . $this->model->insertID)
                ->with('info', 'تم إضافة سند الصرف بنجاح');
        } else {
            return redirect()->back()
                ->with('warning', 'هناك خطأ ما')
                ->withInput();
        }

    }

    public function delete($id)
    {
        $record = $this->model->find($id);
        if (!$record) {
            return redirect()->back()
                ->with('warning', 'الوثيقة غير متاحة');
        }

        if ($this->model->delete($id)) {
            return redirect()->to('dashboard/voucher')
                ->with('info', 'تم حذف الوثيقة بنجاح');
        } else {
            return redirect()->back()
                ->with('warning', 'حدث خطأ أثناء حذف الوثيقة')
                ->withInput();
        }
    }

    public function recover($id)
    {
        if ($this->model->recover($id)) {
            return redirect()->back()
                ->with('info', 'تم استعادة الوثيقة بنجاح');
        } else {
            return redirect()->back()
                ->with('warning', 'حدث خطأ أثناء استعادة الوثيقة')
                ->withInput();
        }
    }

}