<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>رسائل البريد الصادر</h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <table id="table_data" class="table  table-row-bordered border rounded gy-5 gs-7">
                <thead>
                    <tr class="fw-bold fs-6 text-gray-800 px-7">
                        <th>المرسل</th>
                        <th>البريد الالكتروني</th>
                        <th>العنوان</th>
                        <th>التاريخ</th>
                        <th class="text-end">الخيارات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($messages)): ?>
                        <tr>
                            <td> لا توجد رسائل</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td class="text-end"></td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($messages as $message): ?>
                            <tr>
                                <td>
                                    <?= esc($message['name']) ?>
                                </td>
                                <td>
                                    <?= esc($message['email']) ?>
                                </td>
                                <td>
                                    <?= esc($message['subject']) ?>
                                </td>
                                <td>
                                    <?= esc($message['created_at']) ?>
                                </td>

                                <td class="text-end">
                                    <a href="#" class="btn btn-sm btn-light btn-active-light-primary"
                                        data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">الخيارات
                                        <span class="svg-icon svg-icon-5 m-0">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z"
                                                    fill="currentColor" />
                                            </svg>
                                        </span>
                                    </a>

                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4"
                                        data-kt-menu="true">

                                        <div class="menu-item px-3">
                                            <a href="<?= site_url('dashboard/contact_messages/' . $message['id']) ?>"
                                                class="menu-link px-3">عرض</a>
                                        </div>

                                        <div class="menu-item px-3">
                                            <form
                                                action="<?= site_url('dashboard/contact_messages/moveToTrash/' . $message['id']) ?>"
                                                method="post" id="trashForm">
                                                <?= csrf_field() ?>
                                                <a href="#" onclick="document.getElementById('trashForm').submit()"
                                                    class="menu-link px-3">حذف</a>
                                            </form>
                                        </div>

                                    </div>
                                </td>


                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>