<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>إضافة سند قبض</h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <?php if (session()->has('errors')): ?>
                <div class="alert alert-danger d-flex align-items-center p-5">
                    <span class="svg-icon svg-icon-2hx svg-icon-danger me-3"><svg xmlns="http://www.w3.org/2000/svg"
                            width="16" height="16" fill="currentColor" class="bi bi-exclamation-diamond-fill"
                            viewBox="0 0 16 16">
                            <path
                                d="M9.05.435c-.58-.58-1.52-.58-2.1 0L.436 6.95c-.58.58-.58 1.519 0 2.098l6.516 6.516c.58.58 1.519.58 2.098 0l6.516-6.516c.58-.58.58-1.519 0-2.098L9.05.435zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                        </svg></span>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-dark">هناك خطأ!</h4>
                        <?php foreach (session('errors') as $error): ?>
                            <span>
                                <?= $error ?>
                            </span>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif ?>

            <script>
                function main() {
                    var fraction = document.getElementById("amount_number").value.split(".");
                    if (fraction.length == 2) {
                        document.getElementById("amount_text").value = tafqeet(fraction[0]) + " فاصلة " + tafqeet(fraction[1]);
                    }
                    else if (fraction.length == 1) {
                        document.getElementById("amount_text").value = tafqeet(fraction[0]);
                    }
                }
            </script>

            <?= form_open('dashboard/voucher/receipt/create', 'onsubmit="main();"') ?>
            <?= csrf_field() ?>
            <input type="hidden" name="amount_text" id="amount_text" />

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="title"><span class="required">
                        عنوان الوثيقة *ذلك قيمة؟
                    </span></label>
                <input type="text" class="form-control form-control-solid" name="title" id="title" maxlength="255"
                    placeholder="عنوان وثيقة الصرف" value="<?= old('title') ?>" required>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="recipient_name"><span class="required">
                        المسَلِّم
                    </span></label>
                <input type="text" class="form-control form-control-solid" name="recipient_name" id="recipient_name"
                    maxlength="255" placeholder="اسم مسلم المبلغ" value="<?= old('recipient_name') ?>" required>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="amount_number"><span class="required">
                        المبلغ - رقم
                    </span></label>
                <input type="number" class="form-control form-control-solid" name="amount_number" id="amount_number"
                    max="9999999999" step="any" placeholder="المبلغ - رقم" value="<?= old('amount_number') ?>" required>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="cashier_name"><span class="required">
                        أمين الصندوق
                    </span></label>
                <input type="text" class="form-control form-control-solid" name="cashier_name" id="cashier_name"
                    maxlength="255" placeholder="اسم أمين الصندوق" value="<?= old('cashier_name') ?>" required>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="review_name"><span class="required">
                        المراجعة
                    </span></label>
                <input type="text" class="form-control form-control-solid" name="review_name" id="review_name"
                    maxlength="255" placeholder="اسم المراجع" value="<?= old('review_name') ?>" required>
            </div>

            <div class="fv-row mb-7">
                <label class="fs-6 fw-semibold form-label mt-3" for="accreditation_name"><span class="required">
                        الإعتماد
                    </span></label>
                <input type="text" class="form-control form-control-solid" name="accreditation_name"
                    id="accreditation_name" maxlength="255" placeholder="اسم المعتمد"
                    value="<?= old('accreditation_name') ?>" required>
            </div>

            <div class="separator mb-6"></div>

            <div class="d-flex justify-content-end">

                <button type="submit" class="btn btn-primary">
                    <span class="indicator-label">إضافة سند قبض</span>
                    <span class="indicator-progress">برجاء الانتظار ...
                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                </button>

            </div>

            <?= form_close() ?>



        </div>
    </div>
</div>