<?php

namespace App\Models;

use CodeIgniter\Model;

class VoucherModel extends Model
{
    protected $table = 'vouchers';
    protected $primaryKey = 'id';
    protected $returnType = 'App\Entities\Vouchers';
    protected $useSoftDeletes = true;

    protected $allowedFields = ['serial_number', 'voucher_type', 'title', 'amount_number', 'verify_code', 'amount_text', 'cashier_name', 'review_name', 'accreditation_name', 'recipient_name', 'is_accredited', 'media_file', 'created_by', 'place_id', 'is_deleted'];
    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    protected $validationRules = [
        'title' => 'required',
        'amount_number' => 'required|numeric',
        'amount_text' => 'required',
        'created_by' => 'numeric'
    ];

    protected $validationMessages = [
        'title' => [
            'required' => 'عنوان القسيمة مطلوب.'
        ],
        'created_by' => [
            'numeric' => 'يجب أن يكون معرف المستخدم رقمًا.'
        ],
        'amount_number' => [
            'required' => 'المبلغ مطلوب.',
            'numeric' => 'المبلغ يجب أن يكون رقمًا.'
        ],
        'amount_text' => [
            'required' => 'المبلغ مطلوب.',
        ]
    ];

    public function searchVouchers(array $searchParams)
    {
        $query = $this->builder();
        $query->select('id, serial_number, verify_code, amount_number, title, created_at');

        foreach ($searchParams as $field => $value) {
            if (!empty($value)) {
                if ($field === 'serial_number' || $field === 'verify_code') {
                    $query->where($field, $value);
                } else {
                    $query->like($field, $value);
                }
            }
        }

        if (isset($searchParams['serial_number']) && isset($searchParams['verify_code'])) {
            $query->groupStart()
                ->where('serial_number', $searchParams['serial_number'])
                ->where('verify_code', $searchParams['verify_code'])
                ->where('is_deleted', '0')
                ->groupEnd();
        }

        $result = $query->get()->getResult();
        if (!$result) {
            $db = \Config\Database::connect();
            $lastQuery = $db->getLastQuery();
            echo $lastQuery;
        }

        return $result;
    }

    public function getvouchersByType(string $type)
    {
        return $this->where('voucher_type', $type)
            ->findAll();
    }

    public function delete($id = null, bool $purge = false)
    {
        if (!$purge) {
            $data = [
                'is_deleted' => 1,
                'deleted_at' => date('Y-m-d H:i:s')
            ];
            return $this->builder()->where('id', $id)->update($data);
        } else {
            return parent::delete($id, $purge);
        }
    }

    public function recover($id = null)
    {
        $data = [
            'is_deleted' => 0,
            'deleted_at' => null
        ];
        return $this->builder()->where('id', $id)->update($data);
    }

}