<?php

namespace App\Controllers;

class Profileimage extends BaseController
{
    private $Settingsmodel;
    
    public function __construct()
    {
        $this->myUser = service('auth')->getCurrentUser();
        $this->Settingsmodel = new \App\Models\GeneralSettingsModel;
    }

    public function edit()
    {
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'تغيير الصورة الشخصية';

        $data['myUser'] = $this->myUser;

		$data['page'] = view('Profileimage/edit', $data);

		return view('Admin/layouts/default', $data);
    }

    //--------------------------------------

    public function update()
    {
        $user = service('auth')->getCurrentUser();
    
        $file = $this->request->getFile('image');
    
        if (!$file->isValid()) {
            $error = $file->getError();
            if ($error === UPLOAD_ERR_NO_FILE) {
                return redirect()->back()->with('warning', 'لم يتم اختيار ملف');
            }
            return redirect()->back()->with('warning', 'حدث خطأ في تحميل الملف: ' . $file->getErrorString());
        }
    
        $size = $file->getSizeByUnit('mb');
    
        if ($size > 2) {
            return redirect()->back()->with('warning', 'حجم الملف أكبر من المسموح به وهو 2 ميجا');
        }
    
        $type = $file->getMimeType();
    
        if (!in_array($type, ['image/png', 'image/jpeg', 'image/gif'])) {
            return redirect()->back()->with('warning', 'صيغة الملف غير مقبولة المقبول من الصيغ هي (PNG أو JPEG أو GIF)');
        }
    
        $path = ROOTPATH . 'public_html/uploads/profile_images/' . $user->profile_image;
    
        if (is_file($path)) {
            unlink($path);
        }
    
        $newName = $file->getRandomName();
        $uploadPath = ROOTPATH . 'public_html/uploads/profile_images/';
    
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
    
        try {
            service('image')
                ->withFile($file)
                ->convert(IMAGETYPE_PNG)
                ->fit(200, 200, 'center')
                ->save($uploadPath . $newName, 80);
    
        } catch (\Exception $e) {
            return redirect()->back()->with('warning', 'حدث خطأ في تحويل الصورة: ' . $e->getMessage());
        }
    
        $user->profile_image = $newName;
    
        $model = new \App\Models\UserModel;
    
        $model->protect(false)
              ->save($user);
    
        return redirect()->to('dashboard/profile')
                         ->with('info', 'تم رفع صورة الملف الشخصي بنجاح');
    }

    public function delete()
    {
            
            $user = service('auth')->getCurrentUser();
            
            $path = ROOTPATH . 'public_html/uploads/profile_images/' . $user->profile_image;
            
            if (is_file($path)) {
            
                unlink($path);
            }
            
            $user->profile_image = null;
            
            $model = new \App\Models\UserModel;
            
            $model->protect(false)
                  ->save($user);
                  
            return redirect()->to('dashboard/profile')
                             ->with('info', 'تم حذف الصورة بنجاح');

    }

}