<?php

namespace App\Controllers;

class Password extends BaseController
{
	private $Settingsmodel;

	public function __construct()
	{
		$this->Settingsmodel = new \App\Models\GeneralSettingsModel;
	}

    public function redirect()
    {
        return redirect()->to('login');
    }

	public function forgot()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'نسيت كلمة المرور؟';

		return view('Password/forgot', $data);
	}


    public function resetSent()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'تم طلب استعادة كلمة المرور';

		$data['page'] = view('Password/reset_sent', $data);

		return view('layouts/default', $data);
    }

    public function reset($token)
    {
        $model = new \App\Models\UserModel;
        
        $user = $model->getUserForPasswordReset($token);
        
        if ($user) {

            $data['settings'] = $this->Settingsmodel->where('id', 1)->first();
            $data['title'] = 'استعادة كلمة المرور';
    
            $data['token'] = $token;
    
            return view('Password/reset', $data);
            
        } else {
            
            return redirect()->to('login/forgot')
                             ->with('warning', 'برجاء المحاولة مجددا، رابط التفعيل منتهي الصلاحية أو غير صالح');
                             
        }
    }
    
    public function resetSuccess()
    {
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'تم استعادة كلمة المرور';

		$data['page'] = view('Password/reset_success', $data);

		return view('layouts/default', $data);
    }

    //--------------------------------------

    public function processForgot()
    {
        $model = new \App\Models\UserModel;
        
        $user = $model->findByEmail($this->request->getPost('email'));
        
        if ($user && $user->is_active) {
            
            $user->startPasswordReset();
            
            $model->save($user);
            
            $this->sendResetEmail($user);
            
            return redirect()->to("password/resetsent");
            
        } else {
            
            return redirect()->back()
                             ->with('warning', 'لم يتم العثور على أي عضوية نشطة تحت هذا البريد')
                             ->withInput();
        }
    }
    
    public function processReset($token)
    {
        $model = new \App\Models\UserModel;
        
        $user = $model->getUserForPasswordReset($token);
        
        if ($user) {
            
            $user->fill($this->request->getPost());
            
            if ($model->save($user)) {
                
                $user->completePasswordReset();
                
                $model->save($user);
                
                return redirect()->to('password/resetsuccess');
                
            } else {
                
                return redirect()->back()
                                 ->with('errors', $model->errors())
                                 ->with('warning', 'هناك خطأ ما!');
            }
            
        } else {
            
            return redirect()->to('login/forgot')
            ->with('warning', 'برجاء المحاولة مجددا، رابط التفعيل منتهي الصلاحية أو غير صالح');
                             
        }
    }
    
    private function sendResetEmail($user)
    {
        $email = service('email');

        $email->setTo($user->email);

        $email->setSubject('طلب استعادة كلمة المرور');

        $message = view('Password/reset_email', [
            'token' => $user->reset_token
        ]);

        $email->setMessage($message);

        $email->send();
    }


}