<?php

namespace App\Controllers;

class Login extends BaseController
{
	private $model;
	private $Settingsmodel;

	public function __construct()
	{
		$this->model = new \App\Models\UserModel;
		$this->Settingsmodel = new \App\Models\GeneralSettingsModel;
	}

	public function new()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'الصفحة الرئيسية';

		return view('Login/new', $data);
	}

    //--------------------------------------

    public function create()
    {
        $email = $this->request->getPost('email');
        $password = $this->request->getPost('password');
        $remember_me = (bool) $this->request->getPost('remember_me');

        $auth = service('auth');

        if ($auth->login($email, $password, $remember_me)) {

            $redirect_url = session('redirect_url') ?? '';

            unset($_SESSION['redirect_url']);

            return redirect()->to($redirect_url)
                ->with('info', 'تم تسجيل الدخول بنجاح')
                ->withCookies();

        } else {

            return redirect()->back()
                ->withInput()
                ->with('warning', 'تسجيل دخول خاطئ');
        }
    }

    public function delete()
    {
        service('auth')->logout();

        return redirect()->to('logout/message')
        ->withCookies();
    }

    public function showLogoutMessage()
    {
        return redirect()->to('')
            ->with('info', 'تم تسجيل الخروج بنجاح');
    }





}