<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>
                    <?= esc($message['subject']) ?>
                </h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <div class="mw-lg-950px mx-auto w-100">
                <div class="pb-12">
                    <div class="d-flex flex-column gap-7 gap-md-10">

                        <div class="fw-bold fs-2">
                            <?= esc($message['name']) ?>
                            <span class="fs-6">(
                                <?= esc($message['email']) ?>)
                            </span>
                            <br />
                            <span class="text-muted fs-5">
                                <?= esc($message['subject']) ?>
                            </span>
                        </div>

                        <div class="separator"></div>

                        <div class="d-flex flex-column flex-sm-row gap-7 gap-md-10 fw-bold">
                            <div class="flex-root d-flex flex-column">
                                <span class="text-muted">المعرف</span>
                                <span class="fs-5">#
                                    <?= $message['id'] ?>
                                </span>
                            </div>
                            <div class="flex-root d-flex flex-column">
                                <span class="text-muted">التاريخ</span>
                                <span class="fs-5">
                                    <?= date('Y-m-d g:i a', strtotime($message['created_at'])) ?>
                                </span>
                            </div>
                            <div class="flex-root d-flex flex-column">
                                <span class="text-muted">رقم الهاتف</span>
                                <span class="fs-5">
                                    <?= esc($message['phone']) ?>
                                </span>
                            </div>
                        </div>

                        <div class="d-flex flex-column flex-sm-row gap-7 gap-md-10 fw-bold">
                            <div class="flex-root d-flex flex-column">
                                <span class="text-muted">نص الرسالة:</span>
                                <span class="fs-5">
                                    <?php if ($message['folder'] === 'inbox'): ?>
                                        <?= esc($message['message']) ?>
                                    <?php else: ?>
                                        <?= $message['message'] ?>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="d-flex flex-stack flex-wrap mt-lg-20 pt-13">
                    <div class="my-1 me-5">

                        <button type="button" class="btn btn-success my-1 me-12"
                            onclick="window.print();">طباعة</button>

                        <?php if ($message['folder'] === 'inbox'): ?>

                            <?php if ($message['is_read']): ?>
                                <form action="<?= site_url('dashboard/contact_messages/markAsUnread/' . $message['id']) ?>"
                                    method="post" style="display: inline-block;">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn btn-light-warning my-1">تحديد كغير مقروءة</button>
                                </form>
                            <?php else: ?>
                                <form action="<?= site_url('dashboard/contact_messages/markAsRead/' . $message['id']) ?>"
                                    method="post" style="display: inline-block;">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn btn-light-success my-1">تحديد كمقروءة</button>
                                </form>
                            <?php endif; ?>

                            <a href="<?= site_url('dashboard/contact_messages/reply/' . $message['id']) ?>"
                                class="btn btn-light-info my-1">الرد على الرسالة</a>

                        <?php endif; ?>

                    </div>

                    <form action="<?= site_url('dashboard/contact_messages/moveToTrash/' . $message['id']) ?>"
                        method="post" style="display: inline-block;">
                        <?= csrf_field() ?>
                        <button type="submit" class="btn btn-danger my-1">نقل للمحذوفات</button>
                    </form>

                </div>
            </div>

        </div>
    </div>
</div>