<?php

namespace App\Models;

use CodeIgniter\Model;

use App\Libraries\Token;

class GeneralSettingsModel extends Model
{
    protected $table = 'general_settings';

    protected $allowedFields = ['lang_id', 'site_title', 'about_text', 'logo', 'logo_dark', 'icon', 'address', 'email', 're_phone', 'phone', 'facebook', 'twitter', 'instagram', 'youtube'];

    protected $returnType = 'App\Entities\Settings';

    protected $useTimestamps = true;

    protected $validationRules = [
        'site_title' => 'required'
    ];

    protected $validationMessages = [
        'site_title' => [
            'required' => 'برجاء ادخال اسم الموقع'
        ]
    ];


}