<?php

namespace App\Controllers\Admin;


class Admin extends \App\Controllers\BaseController
{
	private $myUser;
	private $Settingsmodel;

	public function __construct()
	{
		$this->myUser = service('auth')->getCurrentUser();
		$this->Settingsmodel = new \App\Models\GeneralSettingsModel;
	}

	public function index()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'لوحة التحكم';

		$data['myUser'] = $this->myUser;
		$data['page'] = view('Admin/index', $data);

		return view('Admin/layouts/default', $data);
	}

	public function settings()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'الإعدادات العامة';

		$data['myUser'] = $this->myUser;
		$data['page'] = view('Admin/settings/gSettings', $data);

		return view('Admin/layouts/default', $data);
	}


	//--------------------------------------

	public function updateSettings()
	{
		
		$data = [
			'site_title' => $this->request->getPost('site_title'),
			'about_text' => $this->request->getPost('about_text'),
			'address' => $this->request->getPost('address'),
			'email' => $this->request->getPost('email'),
			're_phone' => $this->request->getPost('re_phone'),
			'phone' => $this->request->getPost('phone'),
			'facebook' => $this->request->getPost('facebook'),
			'twitter' => $this->request->getPost('twitter'),
			'instagram' => $this->request->getPost('instagram'),
			'youtube' => $this->request->getPost('youtube'),
		];

		if ($logoFile = $this->request->getFile('logo')) {
			if ($logoFile->isValid() && !$logoFile->hasMoved()) {
				$logoName = $logoFile->getRandomName();
				$logoFile->move(ROOTPATH . 'public_html/uploads/logo', $logoName);
				$data['logo'] = $logoName;
			}
		}

		if ($logodFile = $this->request->getFile('logo_dark')) {
			if ($logodFile->isValid() && !$logodFile->hasMoved()) {
				$logodName = $logodFile->getRandomName();
				$logodFile->move(ROOTPATH . 'public_html/uploads/logo', $logodName);
				$data['logo_dark'] = $logodName;
			}
		}

		if ($iconFile = $this->request->getFile('icon')) {
			if ($iconFile->isValid() && !$iconFile->hasMoved()) {
				$iconName = $iconFile->getRandomName();
				$iconFile->move(ROOTPATH . 'public_html/uploads/logo', $iconName);
				$data['icon'] = $iconName;
			}
		}

		if ($this->Settingsmodel->update(1, $data)) {
			return redirect()->to('dashboard/settings')
				->with('info', 'تم تحديث الإعدادات بنجاح');
		} else {
			return redirect()->back()
				->with('errors', $this->Settingsmodel->errors())
				->with('warning', 'هناك خطأ ما')
				->withInput();
		}

	}



}