<!DOCTYPE html>
<html lang="ar" direction="rtl" dir="rtl" style="direction: rtl">

<head>
  <base href="" />
  <title>
    <?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>
    <?= (isset($title)) ? ' - ' . $title : '- لوحة التحكم' ?>
  </title>
  <meta charset="utf-8" />
  <meta name="description" content="نظام إدارة السندات / القسم التقني لشركة الريان" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <?php $assetsAdmin = 'assets'; ?>

  <link rel="shortcut icon"
    href="<?= (!empty($settings->icon)) ? base_url('uploads/logo/' . $settings->icon) : base_url('uploads/logo/icon.png') ?>" />

  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Tajawal:300,400,500,600,700" />

  <link href="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.rtl.css" rel="stylesheet" type="text/css" />
  <link href="<?= base_url($assetsAdmin); ?>/css/style.bundle.rtl.css" rel="stylesheet" type="text/css" />

</head>

<body id="kt_body" data-bs-spy="scroll" data-bs-target="#kt_landing_menu" class="bg-white position-relative app-blank">

  <script>
    var defaultThemeMode = "light"; var themeMode; if (document.documentElement) { if (document.documentElement.hasAttribute("data-bs-theme-mode")) { themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); } else { if (localStorage.getItem("data-bs-theme") !== null) { themeMode = localStorage.getItem("data-bs-theme"); } else { themeMode = defaultThemeMode; } } if (themeMode === "system") { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } document.documentElement.setAttribute("data-bs-theme", themeMode); }
  </script>

  <div class="d-flex flex-column flex-root" id="kt_app_root">

    <div class="mb-0" id="home">

      <div class="bgi-no-repeat bgi-size-contain bgi-position-x-center bgi-position-y-bottom landing-dark-bg"
        style="background-image: url(assets/media/svg/illustrations/landing.svg)">

        <div class="landing-header" data-kt-sticky="true" data-kt-sticky-name="landing-header"
          data-kt-sticky-offset="{default: '200px', lg: '300px'}">
          <div class="container">

            <div class="d-flex align-items-center justify-content-between">

              <div class="d-flex align-items-center flex-equal">

                <button class="btn btn-icon btn-active-color-primary me-3 d-flex d-lg-none" id="kt_landing_menu_toggle">
                  <span class="svg-icon svg-icon-2hx">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z"
                        fill="currentColor" />
                      <path opacity="0.3"
                        d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z"
                        fill="currentColor" />
                    </svg>
                  </span>
                </button>

                <a href="<?= base_url(''); ?>">
                  <img alt="<?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>"
                    src="<?= (!empty($settings->logo_dark)) ? base_url('uploads/logo/' . $settings->logo_dark) : base_url('uploads/logo/logod.svg') ?>"
                    class="logo-default h-25px h-lg-30px" />
                  <img alt="<?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>"
                    src="<?= (!empty($settings->logo)) ? base_url('uploads/logo/' . $settings->logo) : base_url('uploads/logo/logo.svg') ?>"
                    class="logo-sticky h-20px h-lg-25px" />
                </a>

              </div>

              <div class="d-lg-block" id="kt_header_nav_wrapper">
                <div class="d-lg-block p-5 p-lg-0" data-kt-drawer="true" data-kt-drawer-name="landing-menu"
                  data-kt-drawer-activate="{default: true, lg: false}" data-kt-drawer-overlay="true"
                  data-kt-drawer-width="200px" data-kt-drawer-direction="start"
                  data-kt-drawer-toggle="#kt_landing_menu_toggle" data-kt-swapper="true" data-kt-swapper-mode="prepend"
                  data-kt-swapper-parent="{default: '#kt_body', lg: '#kt_header_nav_wrapper'}">

                  <div
                    class="menu menu-column flex-nowrap menu-rounded menu-lg-row menu-title-gray-500 menu-state-title-primary nav nav-flush fs-5 fw-semibold"
                    id="kt_landing_menu">

                    <div class="menu-item">
                      <a class="menu-link nav-link active py-3 px-4 px-xxl-6" href="<?= base_url(''); ?>">الرئيسية</a>
                    </div>

                    <div class="menu-item">
                      <a class="menu-link nav-link py-3 px-4 px-xxl-6" href="<?= base_url('verify'); ?>">تحقق من
                        الوثيقة</a>
                    </div>

                    <?php if (current_user()): ?>
                      <div class="menu-item">
                        <a class="menu-link nav-link py-3 px-4 px-xxl-6" href="<?= base_url('logout'); ?>">تسجيل
                          الخروج</a>
                      </div>
                    <?php endif; ?>

                  </div>

                </div>
              </div>

              <?php if (current_user()): ?>
                <div class="flex-equal text-end ms-1">
                  <a href="<?= base_url('dashboard'); ?>" class="btn btn-info">لوحة التحكم</a>
                </div>
              <?php else: ?>
                <div class="flex-equal text-end ms-1">
                  <a href="<?= base_url('login'); ?>" class="btn btn-success">تسجيل الدخول</a>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </div>

        <div class="d-flex flex-column flex-center w-100 min-h-350px min-h-lg-500px px-9">
          <div class="text-center mb-5 mb-lg-10 py-10 py-lg-20">
            <h1 class="text-white lh-base fw-bold fs-2x fs-lg-3x mb-15">القسم التقني لشركة الريان
              <br />
              <span
                style="background: linear-gradient(to right, #12CE5D 0%, #FFD80C 100%);-webkit-background-clip: text;-webkit-text-fill-color: transparent;">
                <span id="kt_landing_hero_text">
                  <?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>
                </span>
              </span>
            </h1>

            <a href="<?= base_url('verify'); ?>" class="btn btn-primary">تحقق من الوثيقة</a>
          </div>

        </div>
      </div>

      <div class="landing-curve landing-dark-color mb-10 mb-lg-20">
        <svg viewBox="15 12 1470 48" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path
            d="M0 11C3.93573 11.3356 7.85984 11.6689 11.7725 12H1488.16C1492.1 11.6689 1496.04 11.3356 1500 11V12H1488.16C913.668 60.3476 586.282 60.6117 11.7725 12H0V11Z"
            fill="currentColor"></path>
        </svg>
      </div>

    </div>

    <?= (isset($page)) ? $page : $this->renderSection("content") ?>

    <div class="mt-20 mb-n20 position-relative z-index-2">
      <div class="landing-dark-bg pt-20">

        <div class="container">
          <div class="row py-10 py-lg-20">

            <div class="col-lg-9 pe-lg-16 mb-10 mb-lg-0">

              <div class="rounded landing-dark-border p-9 mb-10">
                <h2 class="text-white">هل هناك أي استفسار؟</h2>
                <span class="fw-normal fs-4 text-gray-700">أرسل لنا بريد:
                  <a href="mailto:<?= (!empty($settings->email)) ? esc($settings->email) : 'payments@rayanm.com' ?>"
                    class="text-white opacity-50 text-hover-primary"><?= (!empty($settings->email)) ? esc($settings->email) : 'payments@rayanm.com' ?></a></span>
              </div>

              <div class="rounded landing-dark-border p-9">
                <h2 class="text-white">للتواصل معنا:</h2>
                <span class="fw-normal fs-4 text-gray-700">يمكنكم التواصل معنا من خلال:
                  <a href="tel:<?= (!empty($settings->phone)) ? esc($settings->phone) : '#' ?>"
                    class="text-white opacity-50 text-hover-primary"><?= (!empty($settings->phone)) ? esc($settings->phone) : '#' ?></a>
                  /
                  <a href="tel:<?= (!empty($settings->re_phone)) ? esc($settings->re_phone) : '#' ?>"
                    class="text-white opacity-50 text-hover-primary"><?= (!empty($settings->re_phone)) ? esc($settings->re_phone) : '#' ?></a>
                </span>
              </div>

            </div>

            <div class="col-lg-3 ps-lg-16">
              <div class="d-flex justify-content-center">
                <div class="d-flex fw-semibold flex-column ms-lg-20">

                  <h4 class="fw-bold text-gray-400 mb-6">وسائل التواصل</h4>

                  <?php if (!empty($settings->facebook)): ?>
                    <a href="<?= esc($settings->facebook); ?>" class="mb-6">
                      <img src="<?= base_url('uploads'); ?>/media/facebook.svg" class="h-20px me-2" alt="F" />
                      <span class="text-white opacity-50 text-hover-primary fs-5 mb-6">Facebook</span>
                    </a>
                  <?php endif; ?>
                  <?php if (!empty($settings->twitter)): ?>
                    <a href="<?= esc($settings->twitter); ?>" class="mb-6">
                      <img src="<?= base_url('uploads'); ?>/media/twitter.svg" class="h-20px me-2" alt="" />
                      <span class="text-white opacity-50 text-hover-primary fs-5 mb-6">Twitter</span>
                    </a>
                  <?php endif; ?>
                  <?php if (!empty($settings->instagram)): ?>
                    <a href="<?= esc($settings->instagram); ?>" class="mb-6">
                      <img src="<?= base_url('uploads'); ?>/media/instagram.svg" class="h-20px me-2" alt="" />
                      <span class="text-white opacity-50 text-hover-primary fs-5 mb-6">Instagram</span>
                    </a>
                  <?php endif; ?>
                  <?php if (!empty($settings->youtube)): ?>
                    <a href="<?= esc($settings->youtube); ?>" class="mb-6">
                      <img src="<?= base_url('uploads'); ?>/media/youtube.svg" class="h-20px me-2" alt="" />
                      <span class="text-white opacity-50 text-hover-primary fs-5 mb-6">Youtube</span>
                    </a>
                  <?php endif; ?>
                  <?php if (!empty($settings->address)): ?>
                    <a href="<?= esc($settings->address); ?>" class="mb-6">
                      <img src="<?= base_url('uploads'); ?>/media/arr.svg" class="h-20px me-2" alt="" />
                      <span class="text-white opacity-50 text-hover-primary fs-5 mb-6">العنوان</span>
                    </a>
                  <?php endif; ?>

                </div>
              </div>
            </div>

          </div>
        </div>

        <div class="landing-dark-separator"></div>

        <div class="container">
          <div class="d-flex flex-column flex-md-row flex-stack py-7 py-lg-10">
            <div class="d-flex align-items-center order-2 order-md-1">
              <a href="<?= base_url(''); ?>">
                <img alt="<?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>"
                  src="<?= (!empty($settings->logo_dark)) ? base_url('uploads/logo/' . $settings->logo_dark) : base_url('uploads/logo/logod.svg') ?>"
                  class="h-15px h-md-20px" />
              </a>
              <span class="mx-5 fs-6 fw-semibold text-gray-600 pt-1">&copy;
                <?php echo date('Y'); ?> -
                <?= (!empty($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>
              </span>
            </div>

            <ul class="menu menu-gray-600 menu-hover-primary fw-semibold fs-6 fs-md-5 order-1 mb-5 mb-md-0">
              <li class="menu-item">
                <a href="<?= base_url(''); ?>" target="_blank" class="menu-link px-2">الرئيسية</a>
              </li>
              <li class="menu-item mx-5">
                <a href="<?= base_url('verify'); ?>" target="_blank" class="menu-link px-2">تحقق من الوثيقة</a>
              </li>
              <li class="menu-item">
                <a href="#" class="menu-link px-2">
                  <script>
                    document.write(new Intl.DateTimeFormat('ar-TN-u-ca-islamic', {
                      day: 'numeric',
                      month: 'long',
                      weekday: 'long',
                      year: 'numeric'
                    }).format(Date.now()));
                  </script>
                </a>
              </li>
            </ul>

          </div>
        </div>

      </div>
    </div>

    <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
      <span class="svg-icon">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)"
            fill="currentColor" />
          <path
            d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z"
            fill="currentColor" />
        </svg>
      </span>
    </div>

  </div>

  <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
    <span class="svg-icon">
      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor" />
        <path
          d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z"
          fill="currentColor" />
      </svg>
    </span>
  </div>

  <script>var hostUrl = "<?= base_url($assetsAdmin); ?>/";</script>

  <script src="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.js"></script>
  <script src="<?= base_url($assetsAdmin); ?>/js/scripts.bundle.js"></script>

  <script src="<?= base_url($assetsAdmin); ?>/plugins/custom/fslightbox/fslightbox.bundle.js"></script>
  <script src="<?= base_url($assetsAdmin); ?>/plugins/custom/typedjs/typedjs.bundle.js"></script>

  <script src="<?= base_url($assetsAdmin); ?>/js/custom/landing.js"></script>
  <script src="<?= base_url($assetsAdmin); ?>/js/custom/pages/pricing/general.js"></script>

  <?php if (session()->has('warning')): ?>
    <script>
      toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": false,
        "progressBar": true,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
      };

      toastr.warning("<?= session('warning'); ?>");
    </script>
  <?php endif; ?>
  <?php if (session()->has('info')): ?>
    <script>
      toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": false,
        "progressBar": true,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
      };

      toastr.success("<?= session('info'); ?>");
    </script>
  <?php endif; ?>
  <?php if (session()->has('error')): ?>
    <script>
      toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": false,
        "progressBar": true,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
      };

      toastr.error("<?= session('error'); ?>");
    </script>
  <?php endif; ?>

</body>

</html>