<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>
                    الرد برسالة على:
                    <?= esc($message['subject']) ?>
                </h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <div class="py-5">
                <div class="fw-bold fs-2">
                    <?= esc($message['name']) ?>
                    <span class="fs-6">(
                        <?= esc($message['email']) ?>)
                    </span>
                    <br />
                    <span class="text-muted fs-5">
                        <?= esc($message['subject']) ?>
                    </span>
                </div>

                <div class="separator"></div>

                <div class="d-flex flex-column flex-sm-row gap-7 gap-md-10 fw-bold">
                    <div class="flex-root d-flex flex-column">
                        <span class="text-muted">المعرف</span>
                        <span class="fs-5">#
                            <?= $message['id'] ?>
                        </span>
                    </div>
                    <div class="flex-root d-flex flex-column">
                        <span class="text-muted">التاريخ</span>
                        <span class="fs-5">
                            <?= date('Y-m-d g:i a', strtotime($message['created_at'])) ?>
                        </span>
                    </div>
                    <div class="flex-root d-flex flex-column">
                        <span class="text-muted">رقم الهاتف</span>
                        <span class="fs-5">
                            <?= esc($message['phone']) ?>
                        </span>
                    </div>
                </div>

                <div class="d-flex flex-column flex-sm-row gap-7 gap-md-10 fw-bold">
                    <div class="flex-root d-flex flex-column">
                        <span class="text-muted">نص الرسالة:</span>
                        <span class="fs-5">
                            <p>
                                <?= nl2br($message['message']) ?>
                            </p>
                        </span>
                    </div>
                </div>

            </div>

            <div class="separator my-6"></div>

            <?php if (session()->has('errors')): ?>
                <div class="alert alert-danger d-flex align-items-center p-5">
                    <span class="svg-icon svg-icon-2hx svg-icon-danger me-3"><svg xmlns="http://www.w3.org/2000/svg"
                            width="16" height="16" fill="currentColor" class="bi bi-exclamation-diamond-fill"
                            viewBox="0 0 16 16">
                            <path
                                d="M9.05.435c-.58-.58-1.52-.58-2.1 0L.436 6.95c-.58.58-.58 1.519 0 2.098l6.516 6.516c.58.58 1.519.58 2.098 0l6.516-6.516c.58-.58.58-1.519 0-2.098L9.05.435zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                        </svg></span>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-dark">هناك خطأ!</h4>
                        <?php foreach (session('errors') as $error): ?>
                            <span>
                                <?= $error ?>
                            </span>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif ?>

            <form action="<?= site_url('dashboard/contact_messages/reply_send/' . $message['id']) ?>" method="POST">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label for="message">الرسالة</label>
                    <div id="editor" name="editor" style="height: 250px;" dir="rtl"></div>
                    <input type="hidden" name="message">
                    <?php if (isset($validation) && $validation->hasError('message')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('message') ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">إرسال</button>
                    <a href="<?= site_url('dashboard/contact_messages') ?>" class="btn btn-secondary">إلغاء</a>
                </div>
            </form>

            <script>
                var form = document.querySelector('form');
                form.onsubmit = function () {
                    var editor_content = document.querySelector('input[name="message"]');
                    editor_content.value = quill.root.innerHTML;
                    return validateMessage();
                    
                };

                function validateMessage() {
                    var message_input = document.querySelector('input[name="message"]');
                    if (quill.getText().trim().length === 0) {
                        message_input.classList.add('is-invalid');
                        alert("Please enter a message.");
                        return false;
                    } else {
                        message_input.classList.remove('is-invalid');
                        return true;
                    }
                }
            </script>



        </div>
    </div>
</div>