<!DOCTYPE html>
<html lang="ar" direction="rtl" dir="rtl" style="direction: rtl">

<head>
    <base href="" />
    <title>
        <?= (isset($settings->site_title)) ? $settings->site_title : 'نظام السندات' ?>
        <?= (isset($title)) ? ' - ' . $title : '- لوحة التحكم' ?>
    </title>
    <meta charset="utf-8" />
    <meta name="description" content="نظام إدارة السندات / القسم التقني لشركة الريان" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <?php $assetsAdmin = 'assets'; ?>

    <link rel="shortcut icon"
        href="<?= (!empty($settings->icon)) ? base_url('uploads/logo/' . $settings->icon) : base_url('uploads/logo/icon.png') ?>" />

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Tajawal:300,400,500,600,700" />

    <link href="<?= base_url($assetsAdmin); ?>/plugins/custom/prismjs/prismjs.bundle.rtl.css" rel="stylesheet"
        type="text/css" />

    <link href="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.rtl.css" rel="stylesheet"
        type="text/css" />
    <link href="<?= base_url($assetsAdmin); ?>/css/style.bundle.rtl.css" rel="stylesheet" type="text/css" />

    <link rel="stylesheet" href="<?= base_url($assetsAdmin); ?>/css/print.css" media="print">

</head>

<body>



    <div class="mw-lg-950px mx-auto w-100">

        <div id="printable-content">

            <div class="pb-12">

                <div class="d-flex flex-column gap-7 gap-md-10">

                    <br>

                    <div class="row" style="padding-top: 1.1811in;">

                        <div class="col-sm-6">
                            <div class="row">
                                <div class="col-sm-4">
                                    <span class="text-bold fs-1">
                                        رقم الوثيقة:
                                    </span>
                                </div>
                                <div class="col-sm-8">
                                    <span class="text-bold fs-1" style="font-family: sans-serif;">
                                        <?= esc($voucher->serial_number); ?>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="row">
                                <div class="col-sm-2">
                                    <span class="text-bold fs-1">
                                        التاريخ:
                                    </span>
                                </div>
                                <div class="col-sm-10">
                                    <span class="text-bold fs-1" style="font-family: sans-serif;">
                                        <?= date('Y-m-d', strtotime($voucher->created_at)); ?>
                                    </span>
                                </div>
                            </div>
                        </div>

                    </div>


                    <div class="row">
                        <div class="col-sm-2">
                            <span class="text-bold fs-1">
                                <?php if ($voucher->voucher_type == 'receipt'): ?>
                                    استلمنا من المكرم:
                                <?php elseif ($voucher->voucher_type == 'payment'): ?>
                                    المستلم:
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="col-sm-10">
                            <span class="text-bold fs-1" style="font-family: sans-serif;">
                                <?= esc($voucher->recipient_name); ?>
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-2">
                            <span class="text-bold fs-1">
                                المبلغ:
                            </span>
                        </div>
                        <div class="col-sm-10">
                            <span class="text-bold fs-1" style="font-family: sans-serif;">
                                <?= esc($voucher->amount_number); ?>
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-2">
                            <span class="text-bold fs-1">
                                فقط وقدره:
                            </span>
                        </div>
                        <div class="col-sm-10">
                            <span class="text-bold fs-1">
                                ***
                                <?= esc($voucher->amount_text); ?>
                                /
                                ريالاً سعودياً
                                ***
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-2">
                            <span class="text-bold fs-1">
                                وذلك قيمة:
                            </span>
                        </div>
                        <div class="col-sm-10">
                            <span class="text-bold fs-1" style="font-family: sans-serif;">
                                <?= esc($voucher->title); ?>
                            </span>
                        </div>
                    </div>

                    <br>

                    <div class="col-sm-12 text-center">
                        <div class="fw-bold fs-2">رقم التحقق:
                            <span class="text-bold fs-2" style="font-family: sans-serif;">
                                <?= esc($voucher->verify_code); ?>
                            </span>
                        </div>
                    </div>

                </div>

            </div>

        </div>


        <div class="d-flex flex-stack flex-wrap mt-lg-20 pt-13">
            <div class="my-1 me-5">
                <button type="button" class="btn btn-success my-1 me-12" onclick="printDiv()">
                    طباعة
                </button>
            </div>
        </div>

    </div>

    <script type="text/javascript">
        function printDiv() {
            var printContents = document.getElementById("printable-content").innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>




    <script>var hostUrl = "<?= base_url($assetsAdmin); ?>/";</script>

    <script src="<?= base_url($assetsAdmin); ?>/plugins/global/plugins.bundle.js"></script>
    <script src="<?= base_url($assetsAdmin); ?>/js/scripts.bundle.js"></script>
</body>

</html>