<div class="col-xl-12">
    <div class="card card-flush h-lg-100" id="kt_contacts_main">
        <div class="card-header pt-7" id="kt_chat_contacts_header">
            <div class="card-title">
                <h2>بيانات العضو:
                    <?= esc($user->name) ?>
                </h2>
            </div>
        </div>
        <div class="card-body pt-5">

            <div class="d-flex gap-7 align-items-center">
                <div class="symbol symbol-circle symbol-100px">
                    <?php if ($user->profile_image): ?>
                        <img src="<?= base_url('uploads/profile_images/' . $user->profile_image) ?>" alt="الإدارة">
                    <?php else: ?>
                        <img src="<?= base_url('uploads/profile_images/blank_profile.png') ?>" alt="الإدارة">
                    <?php endif; ?>
                </div>
                <div class="d-flex flex-column gap-2">
                    <h3 class="mb-0">
                        <?= esc($user->name) ?>
                    </h3>
                    <div class="d-flex align-items-center gap-2">
                        <span class="svg-icon svg-icon-2">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.3"
                                    d="M21 19H3C2.4 19 2 18.6 2 18V6C2 5.4 2.4 5 3 5H21C21.6 5 22 5.4 22 6V18C22 18.6 21.6 19 21 19Z"
                                    fill="currentColor" />
                                <path
                                    d="M21 5H2.99999C2.69999 5 2.49999 5.10005 2.29999 5.30005L11.2 13.3C11.7 13.7 12.4 13.7 12.8 13.3L21.7 5.30005C21.5 5.10005 21.3 5 21 5Z"
                                    fill="currentColor" />
                            </svg>
                        </span>
                        <a href="mailto:<?= esc($user->email) ?>" class="text-muted text-hover-primary"><?= esc($user->email) ?></a>
                    </div>
                </div>
            </div>

            <div class="separator my-7"></div>

            <div class="d-flex flex-column gap-5 mt-7">

                <div class="d-flex flex-column gap-1">
                    <div class="fw-bold text-muted">العضو نشط؟</div>
                    <div class="fw-bold fs-5">
                        <?= $user->is_active ? 'نعم' : 'لا' ?>
                    </div>
                </div>
                <div class="d-flex flex-column gap-1">
                    <div class="fw-bold text-muted">العضو مدير؟</div>
                    <div class="fw-bold fs-5">
                        <?= $user->is_admin ? 'نعم' : 'لا' ?>
                    </div>
                </div>
                <div class="d-flex flex-column gap-1">
                    <div class="fw-bold text-muted">أنشئ الحساب في:</div>
                    <div class="fw-bold fs-5">
                        <?= $user->created_at ?>
                    </div>
                </div>
                <div class="d-flex flex-column gap-1">
                    <div class="fw-bold text-muted">تم تعديل بيانات الحساب في:</div>
                    <div class="fw-bold fs-5">
                        <?= $user->updated_at ?>
                    </div>
                </div>

            </div>

        </div>

        <div class="card-footer">
            <a href="<?= base_url('dashboard/users/edit/' . $user->id) ?>" class="btn btn-info">تعديل البيانات</a>
            <?php if ($user->id != current_user()->id): ?>
                <a href="<?= base_url('dashboard/users/delete/' . $user->id); ?>" onclick="return confirm('Are you sure?');"
                    class="btn btn-danger">حذف العضو</a>
            <?php endif; ?>

        </div>

    </div>
</div>