<?php

namespace App\Controllers;

use \App\Entities\HomePage;

class Home extends BaseController
{
	private $Settingsmodel;
	private $current_user;
	private $VoucherModel;

	public function __construct()
	{
		$this->Settingsmodel = new \App\Models\GeneralSettingsModel;
		$this->current_user = service('auth')->getCurrentUser();
		$this->VoucherModel = new \App\Models\VoucherModel;
	}

	public function index()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'الصفحة الرئيسية';

		$data['page'] = view('Home/index', $data);

		return view('layouts/default', $data);
	}

	public function verify()
	{
		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'التحقق من الوثيقة';

		$data['page'] = view('Home/verify', $data);

		return view('layouts/default', $data);
	}

	public function results()
	{
		$searchParams = session('search_params');
		$vouchers = session('search_results');

		if (empty($vouchers)) {
			return redirect()->to('verify')
				->with('error', 'هذه الوثيقة غير متوفرة برجاء التحقق من البيانات')
				->withInput();
		}

		if (isset($this->VoucherModel->errors) && count($this->VoucherModel->errors) > 0) {
			return redirect()->to('verify')
				->with('errors', $this->VoucherModel->errors())
				->with('warning', 'حدث خطأ ما أثناء البحث. برجاء المحاولة مرة أخرى')
				->withInput();
		}

		$data['settings'] = $this->Settingsmodel->where('id', 1)->first();
		$data['title'] = 'نتيجة التحقق من الوثيقة';

		$data['voucher'] = $vouchers[0];

		$data['searchParams'] = $searchParams;

		$data['page'] = view('Home/results', $data);

		$this->clearSearchSession();

		return view('layouts/default', $data);
	}


	//--------------------------------------

	public function search()
	{
		$searchParams = [
			'serial_number' => $this->request->getVar('serial_number'),
			'verify_code' => $this->request->getVar('verify_code')
		];

		session()->set('search_params', $searchParams);

		$vouchers = $this->VoucherModel->searchVouchers($searchParams);

		if (empty($vouchers)) {
			session()->setFlashdata('error', 'هذه الوثيقة غير متوفرة برجاء التحقق من البيانات');
			return redirect()->to('verify')->withInput();
		}

		session()->set('search_results', array_map(function ($voucher) {
			return [
				'id' => $voucher->id,
				'serial_number' => $voucher->serial_number,
				'verify_code' => $voucher->verify_code,
				'amount_number' => $voucher->amount_number,
				'created_at' => $voucher->created_at,
				'title' => $voucher->title,
			];
		}, $vouchers));

		return redirect()->to('verify/results');
	}

	public function clearSearchSession()
	{
		session()->remove('search_params');
		session()->remove('search_results');
	}


}