<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// HOME
$routes->get('/', 'Home::index');
$routes->get('verify', 'Home::verify');
$routes->get('verify/results', 'Home::results');

$routes->post('verify/search', 'Home::search');

// Auth
$routes->get('login', 'Login::new', ['filter' => 'guest']);
$routes->get('logout', 'Login::delete');
$routes->get('logout/message', 'Login::showLogoutMessage');

$routes->get('password', 'Password::redirect');
$routes->get('password/resetsent', 'Password::resetsent');
$routes->get('password/resetsuccess', 'Password::resetSuccess');
$routes->get('password/reset/(:any)', 'Password::reset/$1');
$routes->get('login/forgot', 'Password::forgot', ['filter' => 'guest']);

// Auth admin
$routes->post('login/create', 'Login::create');
$routes->post('password/processForgot', 'Password::processForgot');
$routes->post('password/processReset/(:any)', 'Password::processReset/$1');

// Users
$routes->get('dashboard/users', 'Admin\Users::index');
$routes->get('dashboard/users/(:num)', 'Admin\Users::show/$1');
$routes->get('dashboard/users/new', 'Admin\Users::new');
$routes->get('dashboard/users/edit/(:num)', 'Admin\Users::edit/$1');

// Users admin
$routes->post('dashboard/users/create', 'Admin\Users::create');
$routes->post('dashboard/users/update/(:num)', 'Admin\Users::update/$1');
$routes->get('dashboard/users/delete/(:num)', 'Admin\Users::delete/$1');

// User
$routes->get('dashboard/profile', 'Profile::show');
$routes->get('dashboard/profile/image', 'Profile::image');
$routes->get('dashboard/profile/edit', 'Profile::edit');
$routes->get('dashboard/profile/editpassword', 'Profile::editPassword');
$routes->get('dashboard/profile/authenticate', 'Profile::authenticate');

$routes->get('dashboard/profile/profileimage/edit', 'profileimage::edit');
$routes->get('dashboard/profile/profileimage/delete', 'profileimage::delete');

$routes->post('dashboard/profile/update', 'Profile::update');
$routes->post('dashboard/profile/updatepassword', 'Profile::updatepassword');
$routes->post('dashboard/profile/processauthenticate', 'Profile::processauthenticate');

$routes->post('dashboard/profile/profileimage/update', 'profileimage::update');

// Dashboard
$routes->get('dashboard', 'Admin\Admin::index');
$routes->get('dashboard/settings', 'Admin\Admin::settings');

$routes->post('dashboard/settings/update', 'Admin\Admin::updateSettings');

// Messages
$routes->get('dashboard/contact_messages', 'Admin\ContactMessages::index');
$routes->get('dashboard/contact_messages/compose', 'Admin\ContactMessages::compose');
$routes->get('dashboard/contact_messages/trash', 'Admin\ContactMessages::trash');

$routes->get('dashboard/contact_messages/(:num)', 'Admin\ContactMessages::view/$1');
$routes->get('dashboard/contact_messages/delete/(:num)', 'Admin\ContactMessages::delete/$1');
$routes->get('dashboard/contact_messages/emptyTrash', 'Admin\ContactMessages::emptyTrash');

$routes->post('dashboard/contact_messages/composeMessage', 'Admin\ContactMessages::composeMessage');
$routes->post('dashboard/contact_messages/markAsRead/(:num)', 'Admin\ContactMessages::markAsRead/$1');
$routes->post('dashboard/contact_messages/markAsUnread/(:num)', 'Admin\ContactMessages::markAsUnread/$1');
$routes->post('dashboard/contact_messages/moveToTrash/(:num)', 'Admin\ContactMessages::moveToTrash/$1');

// Voucher
$routes->get('dashboard/voucher', 'Admin\Voucher::index');
$routes->get('dashboard/voucher/(:num)', 'Admin\Voucher::show/$1');
$routes->get('dashboard/voucher/print/(:num)', 'Admin\Voucher::print/$1');
$routes->get('dashboard/voucher/edit/(:num)', 'Admin\Voucher::edit/$1');
$routes->get('dashboard/voucher/receipt', 'Admin\Voucher::indexReceipt');
$routes->get('dashboard/voucher/receipt/new', 'Admin\Voucher::newReceipt');
$routes->get('dashboard/voucher/payment', 'Admin\Voucher::indexPayment');
$routes->get('dashboard/voucher/payment/new', 'Admin\Voucher::newPayment');
$routes->get('dashboard/voucher/trash', 'Admin\Voucher::trash');

$routes->post('dashboard/voucher/receipt/create', 'Admin\Voucher::createReceipt');
$routes->post('dashboard/voucher/payment/create', 'Admin\Voucher::createPayment');
$routes->get('dashboard/voucher/delete/(:num)', 'Admin\Voucher::delete/$1');
$routes->get('dashboard/voucher/recover/(:num)', 'Admin\Voucher::recover/$1');



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
